<?php
defined('BASEPATH') OR exit('No direct script access allowed');
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
	
class Laporan extends CI_Controller {

	function __construct() {
		parent::__construct();
		//validasi jika user belum login
		if ($this->session->userdata('masuk') != TRUE) {
			$url = base_url();
			redirect($url);
			
		}
        
		date_default_timezone_set('Asia/Jakarta');
		$this->load->model('laporan_model');
		$this->load->model('manajer_model');
		$this->load->helper('random');
	//	$this->load->library('fpdf');
	    $this->load->library('Pdf');
	}
public function masuk_transaksi() {
        $kdtoko = $this->session->userdata('kd_toko');			    
		$tanggal = date('Y-m-d');
		$filter = $this->input->get('filter');
		$a = $this->input->get('a');
		$b = $this->input->get('b');
		$c = $this->input->get('c');
		$d = $this->input->get('d');
		$e = $this->input->get('e');
		$f = $this->input->get('f');
		$tgl_awal = $c . "-" . $b . "-" . $a;
		$tgl_akhir = $f . "-" . $e . "-" . $d;
		$data['tgl'] = date('d');
		$data['bln'] = date('m');
		$data['thn'] = date('Y');
		$data['no'] = 1;
		$data['subtot'] = 0;
		$data['diskon'] = 0;
		$data['grandtot'] = 0;
		$data['cash'] = 0;
		$data['debet'] = 0;
		$data['tanggal'] = $tanggal;
		$data['awal'] = $tgl_awal;
		$data['akhir'] = $tgl_akhir;
		$data['filter'] = $filter;
		$data['toko'] = $this->laporan_model->get_toko();
		if ($filter == "ok") {
			$data['penjualan'] = $this->laporan_model->getDatamasukTransaksiFilter($tgl_awal, $tgl_akhir);
		} else {
			$data['penjualan'] = $this->laporan_model->getDatamasukTransaksi($tanggal);
		}
		$this->load->view('laporan/masuk_transaksi', $data);
	}
public function stok_transaksi() {
        $kdtoko = $this->session->userdata('kd_toko');			    
		$tanggal = date('Y-m-d');
		$filter = $this->input->get('filter');
		$a = $this->input->get('a');
		$b = $this->input->get('b');
		$c = $this->input->get('c');
		$d = $this->input->get('d');
		$e = $this->input->get('e');
		$f = $this->input->get('f');
		$tgl_awal = $c . "-" . $b . "-" . $a;
		$tgl_akhir = $f . "-" . $e . "-" . $d;
		$data['tgl'] = date('d');
		$data['bln'] = date('m');
		$data['thn'] = date('Y');
		$data['no'] = 1;
		$data['subtot'] = 0;
		$data['diskon'] = 0;
		$data['grandtot'] = 0;
		$data['cash'] = 0;
		$data['debet'] = 0;
		$data['tanggal'] = $tanggal;
		$data['awal'] = $tgl_awal;
		$data['akhir'] = $tgl_akhir;
		$data['filter'] = $filter;
		$data['toko'] = $this->laporan_model->get_toko();
		if ($filter == "ok") {
			$data['penjualan'] = $this->laporan_model->getDatastokTransaksiFilter($tgl_awal, $tgl_akhir);
		} else {
			$data['penjualan'] = $this->laporan_model->getDatastokTransaksi($tanggal);
		}
		$this->load->view('laporan/stok_transaksi', $data);
	}	
	
public function kartu_stok() {
		$this->load->view('header');
		$this->load->view('laporan/kartu_stok');
	}
	
public function view_kartu_stok() {
		$kd_barang = $this->input->post('kd_barang');
		$kdtoko = $this->input->post('kedai');
		$dari = $this->input->post('dari');
		$smp = $this->input->post('smp');
		$data['masuk']=0;
		$data['keluar']=0;
		$data['stok']=$this->manajer_model->carisaldo($kd_barang,$kdtoko,$dari)->row();
		$data['barang'] = $this->manajer_model->getDataBarang($kd_barang)->row();
		$data['list'] = $this->manajer_model->getListKartuStok($kd_barang,$kdtoko,$dari,$smp);
		$this->load->view('header', $data);
		$this->load->view('laporan/view_kartu_stok');
	}	
	
public function suratjalan() {	
        $nosj = $this->session->userdata('nosj');	
        $ok=$this->db->query("select a.*,b.* from suratjalanheader a
                              left join tabel_toko b on a.kdcabang=b.kd_toko    
                              where a.nobukti='$nosj';");
        $dk=$ok->row_array();
        
        $tujuan=$dk['nm_toko'];
        $tglsj=date_indo($dk['tgl']);
        $pdf = new FPDF('P','mm','A4');
        // membuat halaman baru
        $pdf->AddPage();
        // setting jenis font yang akan digunakan
        
        $pdf->SetFont('Arial','B',16);
        // mencetak string
        $pdf->Cell(190,7,'SURAT JALAN',0,1,'C');
        $pdf->SetFont('Arial','B',12);
        $pdf->Cell(50,10,'No. : '.$nosj,1,0,'L');
        $pdf->Cell(60,10,'Tgl : '.$tglsj,1,0,'L');
        $pdf->Cell(80,10,'Tujuan : '.$tujuan,1,1,'L');
      
        // Memberikan space kebawah agar tidak terlalu rapat
        
        //$pdf->Cell(10,7,'',0,1);
        $pdf->SetFont('Arial','B',10);
        $pdf->Cell(10,6,'No.',1,0);
        $pdf->Cell(15,6,'Kode',1,0);
        $pdf->Cell(70,6,'Nama Barang',1,0);
        $pdf->Cell(15,6,'Satuan',1,0);
        $pdf->Cell(15,6,'Jumlah',1,0);
        $pdf->Cell(15,6,'Retur',1,0);
        $pdf->Cell(50,6,'Keterangan',1,1);
        $pdf->SetFont('Arial','',9);
        $mahasiswa = $this->laporan_model->suratjalan($nosj);
        foreach ($mahasiswa->result() as $row){
            $pdf->Cell(10,5,$row->nourut,1,0);
            $pdf->Cell(15,5,$row->kdbrg,1,0);
            $pdf->Cell(70,5,$row->namabrg,1,0);
            $pdf->Cell(15,5,$row->stn,1,0);
            $pdf->Cell(15,5,number_format($row->qty),1,0,'R');
            $pdf->Cell(15,5,'',1,0);
            $pdf->Cell(50,5,'',1,1);
        }
        $pdf->Cell(40,7,'Dibuat :',1,0,'T');
        $pdf->Cell(40,7,'Checker :',1,0,'T');
        $pdf->Cell(40,7,'Disetujui :',1,0,'T');
        $pdf->Cell(35,7,'Driver :',1,0,'T');
        $pdf->Cell(35,7,'Kedai :',1,1,'T');
        $pdf->Output();
    }
	
	public function suratjalan3() {
	  
        $nosj = $this->session->userdata('nosj');	
        $ok=$this->db->query("select a.*,b.* from suratjalanheader a
                              left join tabel_toko b on a.kdcabang=b.kd_toko    
                              where a.nobukti='$nosj';");
        $dk=$ok->row_array();
        
        $tujuan=$dk['nm_toko'];
        $tglsj=date_indo($dk['tgl']);
        
        $pdf = new FPDF('P','mm','A4');
        // membuat halaman baru
        $pdf->AddPage();
        // setting jenis font yang akan digunakan
        
        $pdf->SetFont('Arial','B',16);
        // mencetak string
        $pdf->Cell(190,7,'SURAT JALAN',0,1,'C');
        $pdf->SetFont('Arial','B',12);
        $pdf->Cell(50,10,'No. : '.$nosj,1,0,'L');
        $pdf->Cell(60,10,'Tgl : '.$tglsj,1,0,'L');
        $pdf->Cell(80,10,'Tujuan : '.$tujuan,1,1,'L');
      
        // Memberikan space kebawah agar tidak terlalu rapat
        
        //$pdf->Cell(10,7,'',0,1);
        $pdf->SetFont('Arial','B',10);
        $pdf->Cell(10,6,'No.',1,0);
        $pdf->Cell(15,6,'Kode',1,0);
        $pdf->Cell(70,6,'Nama Barang',1,0);
        $pdf->Cell(15,6,'Satuan',1,0);
        $pdf->Cell(15,6,'Jumlah',1,0);
        $pdf->Cell(15,6,'Retur',1,0);
        $pdf->Cell(50,6,'Keterangan',1,1);
        $pdf->SetFont('Arial','',9);
        $mahasiswa = $this->laporan_model->suratjalan3($nosj);
        foreach ($mahasiswa->result() as $row){
            $pdf->Cell(10,5,$row->nourut,1,0);
            $pdf->Cell(15,5,$row->kdbrg,1,0);
            $pdf->Cell(70,5,$row->namabrg,1,0);
            $pdf->Cell(15,5,$row->stn,1,0);
            $pdf->Cell(15,5,number_format($row->qty),1,0,'R');
            $pdf->Cell(15,5,'',1,0);
            $pdf->Cell(50,5,'',1,1);
        }
        $pdf->Cell(40,7,'Dibuat :',1,0,'T');
        $pdf->Cell(40,7,'Checker :',1,0,'T');
        $pdf->Cell(40,7,'Disetujui :',1,0,'T');
        $pdf->Cell(35,7,'Driver :',1,0,'T');
        $pdf->Cell(35,7,'Kedai :',1,1,'T');
        $pdf->Output();
    }
	
public function suratjalan2() {	
        $nosj = $this->session->userdata('nosj');	
        $ok=$this->db->query("select a.*,b.* from suratjalanheader a
                              left join tabel_toko b on a.kdcabang=b.kd_toko    
                              where a.nobukti='$nosj';");
        $dk=$ok->row_array();
        $tujuan=$dk['nm_toko'];
        $tglsj=date_indo($dk['tgl']);
        $pdf = new FPDF('P','mm','A4');
        // membuat halaman baru
        $pdf->AddPage();
        // setting jenis font yang akan digunakan
        
        $pdf->SetFont('Arial','B',16);
        // mencetak string
        $pdf->Cell(190,7,'SURAT JALAN',0,1,'C');
        $pdf->SetFont('Arial','B',12);
        $pdf->Cell(50,10,'No. : '.$nosj,1,0,'L');
        $pdf->Cell(60,10,'Tgl : '.$tglsj,1,0,'L');
        $pdf->Cell(80,10,'Tujuan : '.$tujuan,1,1,'L');
      
        // Memberikan space kebawah agar tidak terlalu rapat
        
        //$pdf->Cell(10,7,'',0,1);
        $pdf->SetFont('Arial','B',10);
        $pdf->Cell(10,6,'No.',1,0);
        $pdf->Cell(15,6,'Kode',1,0);
        $pdf->Cell(70,6,'Nama Barang',1,0);
        $pdf->Cell(15,6,'Satuan',1,0);
        $pdf->Cell(15,6,'S.Awal',1,0);
        $pdf->Cell(15,6,'Muat',1,0);
        $pdf->Cell(15,6,'Keluar',1,0);
        $pdf->Cell(15,6,'S.Akhir',1,0);
        $pdf->Cell(50,6,'Keterangan',1,1);
        $pdf->SetFont('Arial','',9);
        $mahasiswa = $this->laporan_model->suratjalan($nosj);
        foreach ($mahasiswa->result() as $row){
            $pdf->Cell(10,5,$row->nourut,1,0);
            $pdf->Cell(15,5,$row->kdbrg,1,0);
            $pdf->Cell(70,5,$row->namabrg,1,0);
            $pdf->Cell(15,5,$row->stn,1,0);
            $pdf->Cell(15,5,number_format($row->sreal),1,0,'R');
            $pdf->Cell(15,5,number_format($row->qty),1,0,'R');
            $pdf->Cell(15,5,'',1,0);
            $pdf->Cell(15,5,'',1,0);
            $pdf->Cell(50,5,'',1,1);
        }
        $pdf->Cell(40,7,'Dibuat :',1,0,'T');
        $pdf->Cell(40,7,'Checker :',1,0,'T');
        $pdf->Cell(40,7,'Disetujui :',1,0,'T');
        $pdf->Cell(35,7,'Driver :',1,0,'T');
        $pdf->Cell(35,7,'Kedai :',1,1,'T');
        $pdf->Output();
    }	
	
public function suratjalan1() {	
        $nosj = $this->session->userdata('nosj');
         $uri = base_url('laporan/saldostok/');
        $up=$this->db->query("update suratjalanheader set stat='1' where nobukti='$nosj' and stat='0';");
        $this->session->set_userdata('statsj', $nosj.'1'); 
        
        header("Location: " . $uri, TRUE);
}
public function unpoststok() {	
        $nobukti = $this->uri->segment(3);
        $uri = base_url('laporan/list_suratjalan');
        $up=$this->db->query("update suratjalanheader set stat='0' where nobukti='$nobukti' and stat='1';");
        header("Location: " . $uri, TRUE);
}
	

public function promo_transaksi() {
        $kdtoko = $this->session->userdata('kd_toko');			    
		$tanggal = date('Y-m-d');
		$filter = $this->input->get('filter');
		$a = $this->input->get('a');
		$b = $this->input->get('b');
		$c = $this->input->get('c');
		$d = $this->input->get('d');
		$e = $this->input->get('e');
		$f = $this->input->get('f');
		$tgl_awal = $c . "-" . $b . "-" . $a;
		$tgl_akhir = $f . "-" . $e . "-" . $d;
		$data['tgl'] = date('d');
		$data['bln'] = date('m');
		$data['thn'] = date('Y');
		$data['no'] = 1;
		$data['subtot'] = 0;
		$data['diskon'] = 0;
		$data['grandtot'] = 0;
		$data['cash'] = 0;
		$data['debet'] = 0;
		$data['tanggal'] = $tanggal;
		$data['awal'] = $tgl_awal;
		$data['akhir'] = $tgl_akhir;
		$data['filter'] = $filter;
		$data['toko'] = $this->laporan_model->get_toko();
		if ($filter == "ok") {
			$data['penjualan'] = $this->laporan_model->getDatapromoTransaksiFilter($tgl_awal, $tgl_akhir);
			$data['penjualantr'] = $this->laporan_model->getDatapromoTransaksiFiltertr($tgl_awal, $tgl_akhir);
		} else {
			$data['penjualan'] = $this->laporan_model->getDatapromoTransaksi($tanggal);
			$data['penjualantr'] = $this->laporan_model->getDatapromoTransaksitr($tanggal);
		}
		$this->load->view('laporan/promo_transaksi', $data);
	}

public function list_suratjalan() {
        $kdtoko = $this->session->userdata('kd_toko');			    
		$tanggal = date('Y-m-d');
		$filter = $this->input->get('filter');
		$a = $this->input->get('a');
		$b = $this->input->get('b');
		$c = $this->input->get('c');
		$d = $this->input->get('d');
		$e = $this->input->get('e');
		$f = $this->input->get('f');
		$tgl_awal = $c . "-" . $b . "-" . $a;
		$tgl_akhir = $f . "-" . $e . "-" . $d;
		$data['tgl'] = date('d');
		$data['bln'] = date('m');
		$data['thn'] = date('Y');
		$data['no'] = 1;
		$data['tanggal'] = $tanggal;
		$data['awal'] = $tgl_awal;
		$data['akhir'] = $tgl_akhir;
		$data['filter'] = $filter;
		$data['toko'] = $this->laporan_model->get_toko();
		if ($filter == "ok") {
			$data['suratjalan'] = $this->laporan_model->getsjTransaksiFilter($tgl_awal, $tgl_akhir);
		} else {
			$data['suratjalan'] = $this->laporan_model->getsjTransaksi($tanggal);
		}
		$this->load->view('laporan/listsuratjalan', $data);
	}	
	
	public function saldostok() {
	    $cabsj = $this->session->userdata('cabsj');
	    $tglsj = $this->session->userdata('tglsj');
	    $statsj = $this->session->userdata('statsj');
	    
	        $nobukti = $this->uri->segment(3);
	        if($nobukti == null) {$nobukti = $this->session->userdata('nosj');}
	        $this->session->set_userdata('nosj', $nobukti);
	        $nos=$this->db->query("select * from suratjalanheader where nobukti='$nobukti';");
	        $stt=$nos->row_array();
		    if(isset($stt)) {
		        $kdcabang=$stt['kdcabang'];
		         $tglsj=$stt['tgl'];
		        $cabsj= $stt['kdcabang'];
		        $statsj=$stt['stat'];
		        }
		        
	    
		$tanggal = date('Y-m-d');
		$filter = $this->input->get('filter');
		$d = $this->input->get('d');
		$e = $this->input->get('e');
		$f = $this->input->get('f');
		$kirim = $this->input->get('kirim');
		$buffer = $this->input->get('buffer');
		if($buffer == null) {$buffer=1;}
		if($buffer == 0) {$buffer=1;}
		$kdcabang = $this->input->get('kedai');
		if($kdcabang == null) {
		    $kdcabang=$cabsj;
		}
		if($kdcabang == null) {
		    $kdcabang='KDR01';
		}
	    $stat='0';
		$ketjual='Semua';
		$ketjenis='Semua';
	
		$tgl_akhir = $f . "-" . $e . "-" . $d;
		$tgl_awal = $f . "-" . $e . "-" . $d;
		if($tglsj==null) {$tglsj=$tgl_akhir;}
		$data['tgl'] = date('d');
		$data['bln'] = date('m');
		$data['thn'] = date('Y');
		$data['no'] = 1;
		$data['tot'] = 0;
		$data['totrp'] = 0;
		$data['totbrt'] = 0;
		$data['totppn'] = 0;
		$data['totreg'] = 0;
		$data['totregrp'] = 0;
		$data['totdo'] = 0;
		$data['totdorp'] = 0;
		$data['totpro'] = 0;
		$data['totprorp'] = 0;
		$data['totgf'] = 0;
		$data['totgfrp'] = 0;
		$data['totgr'] = 0;
		$data['totgrrp'] = 0;
		$data['totsf'] = 0;
		$data['totsfrp'] = 0;
		$data['tanggal'] = $tanggal;
		$data['awal'] = $tgl_awal;
		$data['jual'] = $ketjual;
		$data['akhir'] = $tglsj;
		$data['filter'] = $filter;
		$data['toko'] = $this->laporan_model->get_tokoku($kdcabang);
		if($filter =='ok') {
		    $data['stat'] = $stat;
	    	$data['pemakaian'] = $this->laporan_model->getsaldoBarangFilter($tgl_awal,$kdcabang,$kirim,$buffer);
		} else {
		    $stat='0';
		    $cekstat=$this->db->query("select stat from suratjalanheader where nobukti='$nobukti';");
		    $stt=$cekstat->row_array();
		    if(isset($stt)) {
		        $stat=$stt['stat'];
		        }
		    $data['stat'] = $stat;
		    $data['pemakaian'] = $this->laporan_model->getsaldoBarangFilterno($nobukti);
		}
		$this->load->view('header', $data);
		$this->load->view('laporan/saldostok');
	}
	
	public function updstoknew() {
	     if(isset($_POST['but_update'])){

            if(isset($_POST['update'])){
                foreach($_POST['update'] as $updateid){
                    $qtydo = $_POST['qtydo_'.$updateid];
                    $salary = $_POST['salary_'.$updateid];
                    if($salary !=''  ){
                        $updateUser = "UPDATE suratjalandetail SET 
                            koreksi=".$salary.",
                            qty=qty+".$salary."
                        WHERE id=".$updateid;
                        $this->db->query($updateUser);
                    }
                    if($qtydo !='') {
                        $updateUser = "UPDATE suratjalandetail SET 
                            qty=".$qtydo."
                        WHERE id=".$updateid;
                        $this->db->query($updateUser);
                    }
                    
                }
            }
            
        }
        redirect('laporan/saldostok/', 'refresh');
	}
		public function saldostok1() {
	    $nobukti = $this->session->userdata('nosj');
	    $cabsj = $this->session->userdata('cabsj');
	    $tglsj = $this->session->userdata('tglsj');
	    $statsj = $this->session->userdata('statsj');
		$tanggal = date('Y-m-d');
		$filter = $this->input->get('filter');
		$d = $this->input->get('d');
		$e = $this->input->get('e');
		$f = $this->input->get('f');
		$kdcabang = $this->input->get('kedai');
		if($kdcabang == null) {
		    $kdcabang=$cabsj;
		}
		if($kdcabang == null) {
		    $kdcabang='KDR01';
		}
	    $stat='0';
		$ketjual='Semua';
		$ketjenis='Semua';
	
		$tgl_akhir = $f . "-" . $e . "-" . $d;
		$tgl_awal = $f . "-" . $e . "-" . $d;
		if($tglsj==null) {$tglsj=$tgl_akhir;}
		$data['tgl'] = date('d');
		$data['bln'] = date('m');
		$data['thn'] = date('Y');
		$data['no'] = 1;
		$data['tot'] = 0;
		$data['totrp'] = 0;
		$data['totbrt'] = 0;
		$data['totppn'] = 0;
		$data['totreg'] = 0;
		$data['totregrp'] = 0;
		$data['totdo'] = 0;
		$data['totdorp'] = 0;
		$data['totpro'] = 0;
		$data['totprorp'] = 0;
		$data['totgf'] = 0;
		$data['totgfrp'] = 0;
		$data['totgr'] = 0;
		$data['totgrrp'] = 0;
		$data['totsf'] = 0;
		$data['totsfrp'] = 0;
		$data['tanggal'] = $tanggal;
		$data['awal'] = $tgl_awal;
		$data['jual'] = $ketjual;
		$data['akhir'] = $tglsj;
		$data['filter'] = $filter;
		$data['toko'] = $this->laporan_model->get_tokoku($kdcabang);
		if($filter =='ok') {
		    $data['stat'] = $stat;
	    	$data['pemakaian'] = $this->laporan_model->getsaldoBarangFilter($tgl_awal,$kdcabang);
		} else {
		    $stat='0';
		    $cekstat=$this->db->query("select stat from suratjalanheader where nobukti='$nobukti';");
		    $stt=$cekstat->row_array();
		    if(isset($stt)) {
		        $stat=$stt['stat'];
		        }
		    $data['stat'] = $stat;
		    $data['pemakaian'] = $this->laporan_model->getsaldoBarangFilterno($nobukti);
		}
		$this->load->view('header', $data);
		$this->load->view('laporan/saldostok');
	}
 	public function simpan_do_edit() {
 	    $nobukti = $this->session->userdata('nosj');	
	    $uri = base_url('laporan/saldostok/');
		$kode = $this->input->post('kdbrg');
		$kdtoko = $this->input->post('kdtoko');
		$data['tgl'] = date_indo(date('Y-m-d'));
		$tgl_awal = $this->input->post('tgl');
		$jml = $this->input->post('jml');
		$data['tgl'] = date('d');
		$data['bln'] = date('m');
		$data['thn'] = date('Y');
		$data['no'] = 1;
	//	$nobukti = $this->input->post('nosj');
		$this->db->query("update suratjalandetail set koreksi='$jml',qty=qty+'$jml' where kdbrg='$kode' and nobukti='$nobukti';");
		header("Location: " . $uri, TRUE);
	}	
	
	public function retur() {
		$tanggal = date('Y-m-d');
		$filter = $this->input->get('filter');
		$a = $this->input->get('a');
		$b = $this->input->get('b');
		$c = $this->input->get('c');
		$d = $this->input->get('d');
		$e = $this->input->get('e');
		$f = $this->input->get('f');
		$tgl_awal = $c . "-" . $b . "-" . $a;
		$tgl_akhir = $f . "-" . $e . "-" . $d;
		$data['tgl'] = date('d');
		$data['bln'] = date('m');
		$data['thn'] = date('Y');
		$data['no'] = 1;
		$data['totalretur'] = 0;
		$data['tanggal'] = $tanggal;
		$data['awal'] = $tgl_awal;
		$data['akhir'] = $tgl_akhir;
		$data['filter'] = $filter;
		$data['toko'] = $this->laporan_model->get_toko();
		if ($filter == "ok") {
			$data['retur'] = $this->laporan_model->getDataReturFilter($tgl_awal, $tgl_akhir);
		} else {
			$data['retur'] = $this->laporan_model->getDataRetur($tanggal);
		}
		$this->load->view('laporan/retur', $data);
	}

	public function biaya() {
		$data['bulan'] = date('m');
		$this->load->view('header', $data, FALSE);
		$this->load->view('laporan/biaya');
	}
    public function feedback() {
		$kd_toko = $this->session->userdata('kd_toko');
        $tgl = $this->input->post('utgl');
        $stgl = $this->input->post('stgl');
		$akses = $this->session->userdata('akses');	
		if($tgl == null) {$tgl=date('Y-m-d'); }
		if($stgl == null) {$stgl=date('Y-m-d'); }
		
		
		$data['tanggal'] = $tgl;
		$data['stanggal'] = $stgl;
		$data['no'] = 1;
		$data['noo'] = 1;
		$data['penjualan'] = $this->laporan_model->dataTransaksiHariIni($tgl,$stgl);
		$this->load->view('header', $data);
		$this->load->view('kasir/cetak_feed');
	}
	
	
	public function view_biaya() {
		$tipe = $this->input->post('action');
		$bulan = $this->input->post('bulan');
		$tahun = $this->input->post('tahun');
		$tgl_awal = $tahun . "-" . $bulan . "-01";
		$tgl_akhir = $tahun . "-" . $bulan . "-31";
		$data['toko'] = $this->laporan_model->get_toko();
		$data['bln'] = $bulan;
		$data['thn'] = $tahun;
		if ($tipe == 'Rekap') {
			$data['no'] = 1;
			$data['tot'] = 0;
			$data['tot_a'] = 0;
			$data['tot_b'] = 0;
			$data['tot_c'] = 0;
			$data['tot_d'] = 0;
			$data['tot_tot'] = 0;
			$data['biaya'] = $this->laporan_model->getDataPengeluaranRekap($tgl_awal, $tgl_akhir);
			$this->load->view('laporan/lap_pengeluaran_rekap', $data, FALSE);
		} elseif ($tipe == 'Rinci') {
			$data['no'] = 1;
			$data['tot'] = 0;
			$data['biaya'] = $this->laporan_model->getDataPengeluaranRinci($tgl_awal, $tgl_akhir);
			$this->load->view('laporan/lap_pengeluaran_rinci', $data, FALSE);
		}
	}

	public function nilai_persediaan() {
		$nilai_persediaan = $this->laporan_model->getNilaiPersediaan();
		$data['toko'] = $this->laporan_model->get_toko();
		if ($nilai_persediaan) {
			$data['no'] = 1;
			$data['tot'] = 0;
			$data['tot_beli'] = 0;
			$data['tot_jual'] = 0;
			$data['tot_nbeli'] = 0;
			$data['tot_njual'] = 0;
			$data['nilai_modal'] = 0;
			$data['nilai_jual'] = 0;
			$data['nilai_persediaan'] = $nilai_persediaan;
			$this->load->view('laporan/lap_nilai_persediaan', $data, FALSE);
		}
	}

	public function pembelian() {
		$tanggal = date('Y-m-d');
		$filter = $this->input->get('filter');
		$a = $this->input->get('a');
		$b = $this->input->get('b');
		$c = $this->input->get('c');
		$d = $this->input->get('d');
		$e = $this->input->get('e');
		$f = $this->input->get('f');
		$tgl_awal = $c . "-" . $b . "-" . $a;
		$tgl_akhir = $f . "-" . $e . "-" . $d;
		$data['tgl'] = date('d');
		$data['bln'] = date('m');
		$data['thn'] = date('Y');
		$data['no'] = 1;
		$data['tot'] = 0;
		$data['tot_harga'] = 0;
		$data['tanggal'] = $tanggal;
		$data['awal'] = $tgl_awal;
		$data['akhir'] = $tgl_akhir;
		$data['filter'] = $filter;
		$data['toko'] = $this->laporan_model->get_toko();
		if ($filter == "ok") {
			$data['pembelian'] = $this->laporan_model->getDataPembelianFilter($tgl_awal, $tgl_akhir);
		} else {
			$data['pembelian'] = $this->laporan_model->getDataPembelian($tanggal);
		}
		$this->load->view('laporan/pembelian', $data);
	}

	public function penjualan_transaksi() {
		$tanggal = date('Y-m-d');
		$filter = $this->input->get('filter');
		$a = $this->input->get('a');
		$b = $this->input->get('b');
		$c = $this->input->get('c');
		$d = $this->input->get('d');
		$e = $this->input->get('e');
		$f = $this->input->get('f');
		$tgl_awal = $c . "-" . $b . "-" . $a;
		$tgl_akhir = $f . "-" . $e . "-" . $d;
		$data['tgl'] = date('d');
		$data['bln'] = date('m');
		$data['thn'] = date('Y');
		$data['no'] = 1;
		$data['subtot'] = 0;
		$data['diskon'] = 0;
		$data['grandtot'] = 0;
		$data['cash'] = 0;
		$data['debet'] = 0;
		$data['tanggal'] = $tanggal;
		$data['awal'] = $tgl_awal;
		$data['akhir'] = $tgl_akhir;
		$data['filter'] = $filter;
		$data['toko'] = $this->laporan_model->get_toko();
		if ($filter == "ok") {
			$data['penjualan'] = $this->laporan_model->getDataPenjualanTransaksiFilter($tgl_awal, $tgl_akhir);
		} else {
			$data['penjualan'] = $this->laporan_model->getDataPenjualanTransaksi($tanggal);
		}
		$this->load->view('laporan/penjualan_transaksi', $data);
	}
	
	public function penjualan_promo() {
		$tanggal = date('Y-m-d');
		$filter = $this->input->get('filter');
		$a = $this->input->get('a');
		$b = $this->input->get('b');
		$c = $this->input->get('c');
		$d = $this->input->get('d');
		$e = $this->input->get('e');
		$f = $this->input->get('f');
		$kdpromo='032';
		$tgl_awal = $c . "-" . $b . "-" . $a;
		$tgl_akhir = $f . "-" . $e . "-" . $d;
		$data['tgl'] = date('d');
		$data['bln'] = date('m');
		$data['thn'] = date('Y');
		$data['no'] = 1;
		$data['subtot'] = 0;
		$data['diskon'] = 0;
		$data['grandtot'] = 0;
		$data['cash'] = 0;
		$data['debet'] = 0;
		$data['tanggal'] = $tanggal;
		$data['awal'] = $tgl_awal;
		$data['akhir'] = $tgl_akhir;
		$data['filter'] = $filter;
		$data['toko'] = $this->laporan_model->get_toko();
		if ($filter == "ok") {
			$data['penjualan'] = $this->laporan_model->getDataPenjualanpromoFilter($tgl_awal, $tgl_akhir,$kdpromo);
		} else {
			$data['penjualan'] = $this->laporan_model->getDataPenjualanpromo($tanggal,$kdpromo);
		}
		$this->load->view('laporan/penjualan_promo', $data);
	}

	public function penjualan_barang() {
		$tanggal = date('Y-m-d');
		$filter = $this->input->get('filter');
		$excel = $this->input->get('action');
		$a = $this->input->get('a');
		$b = $this->input->get('b');
		$c = $this->input->get('c');
		$d = $this->input->get('d');
		$e = $this->input->get('e');
		$f = $this->input->get('f');
		$jenis=$a;
		$jual=$b;
		$ketjual='Semua';
		$ketjenis='Semua';
		if ($b=='s1') {$ketjual='Siang'; }
		if ($b=='s2') {$ketjual='Malam'; }
		
		if ($a=='al') {$ketjenis='Semua'; }
		if ($a=='tl') {$ketjenis='Total'; }
		if ($a=='do') {$ketjenis='DO'; }
		if ($a=='pr') {$ketjenis='Promo'; }
		if ($a=='gf') {$ketjenis='Gofood'; }
		if ($a=='gr') {$ketjenis='Grabfood'; }
		if ($a=='sp') {$ketjenis='Shopeefood'; }
		if ($a=='rg') {$ketjenis='Reguler'; }
		
		$tgl_akhir = $f . "-" . $e . "-" . $d;
		$tgl_awal = $f . "-" . $e . "-" . $d;
			
		
		    $data['tgl'] = date('d');
		    $data['bln'] = date('m');
		    $data['thn'] = date('Y');
		    $data['no'] = 1;
		    $data['tot'] = 0;
		    $data['totrp'] = 0;
		    $data['totbrt'] = 0;
		    $data['totppn'] = 0;
		    $data['totreg'] = 0;
		    $data['totregrp'] = 0;
		    $data['totdo'] = 0;
		    $data['totdorp'] = 0;
		    $data['totpro'] = 0;
		    $data['totprorp'] = 0;
		    $data['totgf'] = 0;
		    $data['totgfrp'] = 0;
		    $data['totgr'] = 0;
		    $data['totgrrp'] = 0;
		    $data['totsf'] = 0;
		    $data['totsfrp'] = 0;
		    $data['tanggal'] = $tanggal;
		    $data['awal'] = $tgl_awal;
		    $data['jual'] = $ketjual;
		    $data['jenis'] = $jenis;
		    $data['ketjenis'] = $ketjenis;
		    $data['akhir'] = $tgl_akhir;
		    $data['filter'] = $filter;
		    $data['toko'] = $this->laporan_model->get_toko();
		    $data['penjualan'] = $this->laporan_model->getDataPenjualanBarang($tanggal);
		     
		    
		if ($filter == "ok") {
			$data['penjualan'] = $this->laporan_model->getDataPenjualanBarangFilter($tgl_awal, $tgl_akhir,$jual);
		    } 
		if ($excel == "excel") {    
		    $data['penjualan'] = $this->laporan_model->getDataPenjualanBarangexcelall($tgl_awal, $tgl_akhir,$jual);
		    $data['penjualansiang'] = $this->laporan_model->getDataPenjualanBarangexcelsiang($tgl_awal, $tgl_akhir,$jual);
		    $data['penjualanmalam'] = $this->laporan_model->getDataPenjualanBarangexcelmalam($tgl_awal, $tgl_akhir,$jual);
		    $this->load->view('laporan/penjualan_barang_excel', $data);
		    }
	
	$this->load->view('laporan/penjualan_barang', $data);   	
	
	}

	public function pemakaian_barang() {
		$tanggal = date('Y-m-d');
		$filter = $this->input->get('filter');
		$d = $this->input->get('d');
		$e = $this->input->get('e');
		$f = $this->input->get('f');
		$kdcabang = $this->input->get('kedai');
		if($kdcabang ==null) {$kdcabang = $this->session->userdata('kd_toko');	}
        if($kdcabang ==null) {$kdcabang='kdr01';}	
		$ketjual='Semua';
		$ketjenis='Semua';
	
		$tgl_akhir = $f . "-" . $e . "-" . $d;
		$tgl_awal = $f . "-" . $e . "-" . $d;
		$data['tgl'] = date('d');
		$data['bln'] = date('m');
		$data['thn'] = date('Y');
		$data['no'] = 1;
		$data['tot'] = 0;
		$data['totrp'] = 0;
		$data['totbrt'] = 0;
		$data['totppn'] = 0;
		$data['totreg'] = 0;
		$data['totregrp'] = 0;
		$data['totdo'] = 0;
		$data['totdorp'] = 0;
		$data['totpro'] = 0;
		$data['totprorp'] = 0;
		$data['totgf'] = 0;
		$data['totgfrp'] = 0;
		$data['totgr'] = 0;
		$data['totgrrp'] = 0;
		$data['totsf'] = 0;
		$data['totsfrp'] = 0;
		$data['tanggal'] = $tanggal;
		$data['awal'] = $tgl_awal;
		$data['jual'] = $ketjual;
		$data['akhir'] = $tgl_akhir;
		$data['filter'] = $filter;
		if ($filter == "ok") {
		    $data['toko'] = $this->laporan_model->get_tokoku($kdcabang);
			$data['pemakaian'] = $this->laporan_model->getDataPakaiBarangFilter($tgl_awal,$kdcabang);
		} else {
		    $kdcabang = $this->session->userdata('kd_toko');
		    $data['toko'] = $this->laporan_model->get_toko();
		    $data['pemakaian'] = $this->laporan_model->getDataPakaiBarang($tanggal,$kdcabang);
		}
		$this->load->view('laporan/pemakaian_barang', $data);
	}
		public function pemakaian_barangh() {
		$tanggal = date('Y-m-d');
		$filter = $this->input->get('filter');
		$d = $this->input->get('d');
		$e = $this->input->get('e');
		$f = $this->input->get('f');
		$kdcabang = $this->input->get('kedai');
		if($kdcabang ==null) {$kdcabang = $this->session->userdata('kd_toko');	}
        if($kdcabang ==null) {$kdcabang='kdr01';}	
		$ketjual='Semua';
		$ketjenis='Semua';
	
		$tgl_akhir = $f . "-" . $e . "-" . $d;
		$tgl_awal = $f . "-" . $e . "-" . $d;
		$data['tgl'] = date('d');
		$data['bln'] = date('m');
		$data['thn'] = date('Y');
		$data['no'] = 1;
		$data['tot'] = 0;
		$data['totrp'] = 0;
		$data['totbrt'] = 0;
		$data['totppn'] = 0;
		$data['totreg'] = 0;
		$data['totregrp'] = 0;
		$data['totdo'] = 0;
		$data['totdorp'] = 0;
		$data['totpro'] = 0;
		$data['totprorp'] = 0;
		$data['totgf'] = 0;
		$data['totgfrp'] = 0;
		$data['totgr'] = 0;
		$data['totgrrp'] = 0;
		$data['totsf'] = 0;
		$data['totsfrp'] = 0;
		$data['tanggal'] = $tanggal;
		$data['awal'] = $tgl_awal;
		$data['jual'] = $ketjual;
		$data['akhir'] = $tgl_akhir;
		$data['filter'] = $filter;
		if ($filter == "ok") {
		    $data['toko'] = $this->laporan_model->get_tokoku($kdcabang);
			$data['pemakaian'] = $this->laporan_model->getDataPakaiBarangFilterh($tgl_awal,$kdcabang);
		} else {
		    $kdcabang = $this->session->userdata('kd_toko');
		    $data['toko'] = $this->laporan_model->get_toko();
		    $data['pemakaian'] = $this->laporan_model->getDataPakaiBarang($tanggal,$kdcabang);
		}
		$this->load->view('laporan/pemakaian_barang_new', $data);
	}


	public function profit() {
		$tanggal = date('Y-m-d');
		$filter = $this->input->get('filter');
		$a = $this->input->get('a');
		$b = $this->input->get('b');
		$c = $this->input->get('c');
		$d = $this->input->get('d');
		$e = $this->input->get('e');
		$f = $this->input->get('f');
		$tgl_awal = $c . "-" . $b . "-" . $a;
		$tgl_akhir = $f . "-" . $e . "-" . $d;
		$data['tgl'] = date('d');
		$data['bln'] = date('m');
		$data['thn'] = date('Y');
		$data['no'] = 1;
		$data['noo'] = 1;
		$data['tot_item'] = 0;
		$data['tot_modal'] = 0;
		$data['tot_pendapatan'] = 0;
		$data['tot_profit'] = 0;
		$data['totbiaya'] = 0;
		$data['tanggal'] = $tanggal;
		$data['awal'] = $tgl_awal;
		$data['akhir'] = $tgl_akhir;
		$data['filter'] = $filter;
		$data['toko'] = $this->laporan_model->get_toko();
		if ($filter == "ok") {
			$data['profit'] = $this->laporan_model->getDataProfit($tgl_awal, $tgl_akhir);
			$data['subdiskon'] = $this->laporan_model->getDiskonBarang($tgl_awal, $tgl_akhir)->row();
			$data['subdisakhir'] = $this->laporan_model->getDiskonAkhir($tgl_awal, $tgl_akhir)->row();
			$data['biaya'] = $this->laporan_model->getDataPengeluaranRinci($tgl_awal, $tgl_akhir);
		} else {
			$data['profit'] = $this->laporan_model->getDataProfit1($tanggal);
			$data['subdiskon'] = $this->laporan_model->getDiskonBarang1($tanggal)->row();
			$data['subdisakhir'] = $this->laporan_model->getDiskonAkhir1($tanggal)->row();
			$data['biaya'] = $this->laporan_model->getDataPengeluaranRinci1($tanggal);
		}
		$this->load->view('laporan/profit', $data);
	}

	public function rekap() {
		$this->load->model('grafik_model');
		$data['year'] = date('Y');
		$data['bulan'] = date('m');
		$data['tahun'] = $this->grafik_model->getTahunJual()->result_array();
		$this->load->view('header', $data, FALSE);
		$this->load->view('laporan/pilih_bulan');
	}

	public function rekapitulasi_penjualan() {
		$tahun = $this->input->post('tahun');
		$bulan = $this->input->post('bulan');
		$data_rekap = $this->laporan_model->getDataRekap($tahun, $bulan)->result();
		$data['diskon'] = $this->laporan_model->getDiskon($tahun, $bulan)->result();
		$data['toko'] = $this->laporan_model->get_toko();
		$data['tahun'] = $tahun;
		$data['bulan'] = $bulan;
		$data['rekap'] = $data_rekap;
		$data['aa'] = 0;
		$data['bb'] = 0;
		$data['cc'] = 0;
		$data['dd'] = 0;
		$data['ee'] = 0;
		$data['ff'] = 0;
		$data['gg'] = 0;
		$data['tot'] = 0;
		$data['tot_a'] = 0;
		$data['tot_b'] = 0;
		$data['tot_c'] = 0;
		$data['tot_d'] = 0;
		$data['tot_tot'] = 0;
		$data['biaya'] = $this->laporan_model->getDataPengeluaranRekapitulasi($tahun, $bulan);
		$this->load->view('laporan/lap_rekap', $data, FALSE);
	}
	public function penjualan_barang1() {
		$tanggal = date('Y-m-d');
		$filter = $this->input->get('filter1');
		$kdtoko = $this->input->get('kedai');
		$a = $this->input->get('a');
		$b = $this->input->get('b');
		$c = $this->input->get('c');
		$d = $this->input->get('d');
		$e = $this->input->get('e');
		$f = $this->input->get('f');
		$jenis=$a;
		$jual=$b;
		$ketjual='Semua';
		$ketjenis='Semua';
		if ($b=='s1') {$ketjual='Siang'; }
		if ($b=='s2') {$ketjual='Malam'; }
		
		if ($a=='al') {$ketjenis='Semua'; }
		if ($a=='tl') {$ketjenis='Total'; }
		if ($a=='do') {$ketjenis='DO'; }
		if ($a=='pr') {$ketjenis='Promo'; }
		if ($a=='gf') {$ketjenis='Gofood'; }
		if ($a=='gr') {$ketjenis='Grabfood'; }
		if ($a=='sp') {$ketjenis='Shopeefood'; }
		if ($a=='rg') {$ketjenis='Reguler'; }
		
		$tgl_akhir = $f . "-" . $e . "-" . $d;
		$tgl_awal = $f . "-" . $e . "-" . $d;
		$data['tgl'] = date('d');
		$data['bln'] = date('m');
		$data['thn'] = date('Y');
		$data['no'] = 1;
		$data['tot'] = 0;
		$data['totrp'] = 0;
		$data['totbrt'] = 0;
		$data['totppn'] = 0;
		$data['totreg'] = 0;
		$data['totregrp'] = 0;
		$data['totdo'] = 0;
		$data['totdorp'] = 0;
		$data['totpro'] = 0;
		$data['totprorp'] = 0;
		$data['totgf'] = 0;
		$data['totgfrp'] = 0;
		$data['totgr'] = 0;
		$data['totgrrp'] = 0;
		$data['totsf'] = 0;
		$data['totsfrp'] = 0;
		$data['tanggal'] = $tanggal;
		$data['awal'] = $tgl_awal;
		$data['jual'] = $ketjual;
		$data['jenis'] = $jenis;
		$data['ketjenis'] = $ketjenis;
		$data['akhir'] = $tgl_akhir;
		$data['filter'] = $filter;
		$data['toko'] = $this->laporan_model->get_tokoku($kdtoko);
		if ($filter == "ok1") {
			$data['penjualan'] = $this->laporan_model->getDataPenjualanBarangFilter1($tgl_awal, $tgl_akhir,$jual,$kdtoko);
		} else {
			$data['penjualan'] = $this->laporan_model->getDataPenjualanBarang1($tanggal,$kdtoko);
		}
		$this->load->view('laporan/penjualan_barang1', $data);
	}

}

/* End of file Laporan.php */
/* Location: ./application/controllers/Laporan.php */